VERSION 5.00
Object = "{F2F30570-0799-43CA-8CCA-0A7AAD89C3DD}#1.0#0"; "MCSCOMM.OCX"
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Begin VB.Form Form1 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Bascom Bootloader  Evertdekker.com 2010"
   ClientHeight    =   3075
   ClientLeft      =   45
   ClientTop       =   435
   ClientWidth     =   5250
   Icon            =   "BascomBootloader.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   3075
   ScaleWidth      =   5250
   StartUpPosition =   2  'CenterScreen
   Begin mcscomm.CommX CommX1 
      Height          =   495
      Left            =   1080
      TabIndex        =   0
      Top             =   2160
      Visible         =   0   'False
      Width           =   1095
      Object.Visible         =   -1  'True
      AutoScroll      =   0   'False
      AutoSize        =   0   'False
      Caption         =   "CommX"
      Color           =   -2147483633
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      KeyPreview      =   0   'False
      PixelsPerInch   =   96
      Scaled          =   -1  'True
      DropTarget      =   0   'False
      HelpFile        =   ""
      DoubleBuffered  =   0   'False
      Enabled         =   -1  'True
      Cursor          =   0
      COMPORT         =   1
      BAUDRATE        =   19200
   End
   Begin VB.Timer Timer1 
      Left            =   4560
      Top             =   2760
   End
   Begin VB.ComboBox ComboBaud 
      Height          =   315
      ItemData        =   "BascomBootloader.frx":014A
      Left            =   120
      List            =   "BascomBootloader.frx":0160
      Style           =   2  'Dropdown List
      TabIndex        =   7
      Top             =   1200
      Width           =   1575
   End
   Begin VB.ComboBox ComboComport 
      Height          =   315
      ItemData        =   "BascomBootloader.frx":018C
      Left            =   120
      List            =   "BascomBootloader.frx":01A2
      Style           =   2  'Dropdown List
      TabIndex        =   6
      Top             =   720
      Width           =   1575
   End
   Begin VB.CommandButton BtOpenComm 
      Caption         =   "&Open comm"
      Height          =   375
      Left            =   3720
      TabIndex        =   5
      Top             =   720
      Width           =   1215
   End
   Begin VB.CommandButton BtStart 
      Caption         =   "&Start"
      Enabled         =   0   'False
      Height          =   375
      Left            =   3720
      TabIndex        =   4
      Top             =   1200
      Width           =   1215
   End
   Begin VB.CommandButton Command1 
      Caption         =   "="
      Height          =   285
      Left            =   4440
      TabIndex        =   3
      Top             =   240
      Width           =   495
   End
   Begin VB.TextBox Text2 
      Height          =   285
      Left            =   120
      TabIndex        =   2
      Text            =   "Choose your hex file"
      Top             =   240
      Width           =   4215
   End
   Begin VB.TextBox Text1 
      BeginProperty Font 
         Name            =   "Courier New"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   1095
      Left            =   120
      Locked          =   -1  'True
      MultiLine       =   -1  'True
      TabIndex        =   1
      Top             =   1800
      Width           =   4935
   End
   Begin MSComDlg.CommonDialog CommonDialog1 
      Left            =   2760
      Top             =   1440
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
      Filter          =   "Hex (*.Hex)|*.Hex|"
   End
   Begin VB.Label Label3 
      Caption         =   "Ver 1.01 23-2-2011"
      BeginProperty Font 
         Name            =   "MS Serif"
         Size            =   6
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   135
      Left            =   120
      TabIndex        =   10
      Top             =   2880
      Width           =   1695
   End
   Begin VB.Label Label2 
      Caption         =   "Baudrate"
      Height          =   255
      Left            =   1800
      TabIndex        =   9
      Top             =   1200
      Width           =   735
   End
   Begin VB.Label Label1 
      Caption         =   "Port"
      Height          =   255
      Left            =   1800
      TabIndex        =   8
      Top             =   840
      Width           =   615
   End
   Begin VB.Shape LedOpen 
      FillColor       =   &H00E0E0E0&
      FillStyle       =   0  'Solid
      Height          =   375
      Left            =   3360
      Shape           =   3  'Circle
      Top             =   720
      Width           =   255
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'=====================================================
'= Pc-side bootloader for the Bascom AVR bootloader  =
'= Use for free with non commercial application      =
'= EvertDekker.com 15-06-2010 VB6-SP6                =
'= Version 1.01 23-02-2011
'=====================================================
' Rev 1.01 removed CommX1.SETDTR = False from BtOpencomm, no idea why it was there
'=====================================================
' Bascom uses Xmodem protocol for communication with the AVR bootloader
' Transmission is initialized by send 123dec to the AVR
' AVR will response with NACK
' Then the first block of 128bytes will be send, with some overhead total of 132 bytes;
' <SOH><Blocknumber><inverted Blocknumber><128bytes data><Xmodem cheksum>
' AVR will response with ACK
' All blocks will be send. If the last block is not completely full (128bytes) the open spaces will be filled with &H1A
' Tranmission will be finalized by sending 4dec to the AVR.
'
Public PortIsopen As Boolean                'Dim some global variable
Public Ack As Boolean
Public Nack As Boolean
Public AckTimeout As Boolean
Public Retry As Byte
Public Bytecount As Byte
Public Blocknumber As Byte
Public Bigblock As Byte
Private SendBuffer(132) As Byte
Private Sub BtOpenComm_Click()              'Open the commport
 If PortIsopen = False Then                 'McsComm from Mcselec is used, this control will NOT give a error if the port not exist of will not open
    CommX1.BAUDRATE = Val(ComboBaud)        'http://www.mcselec.com/index.php?option=com_docman&task=doc_download&gid=151&Itemid=54
    CommX1.COMPORT = Val(ComboComport)
    CommX1.OPEN
    LedOpen.FillColor = vbGreen
    BtOpenComm.Caption = "&Close"
    PortIsopen = True
    'CommX1.SETDTR = False
 Else
    CloseComport
 End If
End Sub
Private Sub CloseComport()                  'Close the comport
    CommX1.Close
    LedOpen.FillColor = &HE0E0E0
    BtOpenComm.Caption = "&Open"
    PortIsopen = False
    Text1 = Text1 & vbCrLf & "Closing comm port"
End Sub

Private Sub ComboBaud_Click()               'Save the changed setting
SaveSetting "Evert", "BascomBootloader", "CommBaud", ComboBaud
End Sub

Private Sub ComboComport_Click()            'Save the changed setting
SaveSetting "Evert", "BascomBootloader", "Commport", ComboComport
End Sub

Private Sub Command1_Click()                'Select the filename
CommonDialog1.ShowOpen
Text2.Text = CommonDialog1.Filename
End Sub

Private Sub BtStart_Click()
Open Text2.Text For Input As #1             'Open the hexfile
BtStart.Enabled = False
InitTransmission
End Sub
Private Sub StartTimer(T As Long)           'Starts the timeout timer
Timer1.Interval = T
Timer1 = 0
Timer1.Enabled = True
End Sub
Private Sub InitTransmission()              'Setup the tranmission with the AVR by sending 123dec
 Retry = 0                                  'First try
Send:
 Text1 = Text1 & vbCrLf & "Init Transmission, sending 123"     'Show us something to watch
 Ack = False: Nack = False: AckTimeout = False                'Reset Nack and Ack flag
  CommX1.Send Chr(123)                      'Send init byte to the AVR
    StartTimer (1000)                        'Start the timeout timer
     Do                                     'Do nothing until there's a Ack, nack or timeout
       DoEvents                             'Give cpu time back
     Loop Until Ack = True Or Nack = True Or AckTimeout = True
If AckTimeout = True Then                   'Timeout occured lets try it again
    Retry = Retry + 1                       'Incr retry counter
     Text1 = Text1 & vbCrLf & "Retry: " & Retry
     If Retry > 15 Then                      'To many retry's
        Beep
        Text1 = Text1 & vbCrLf & "ABORT To many retry's"
        Exit Sub                      'Going out of here
     End If
    GoTo Send                               'Retry, so jump back to starting point sending
End If
Timer1.Enabled = False                      'Received Nack, timeout timer must be stopped
If Nack = True Then ReadHexFile             'Goto the Send_data routine 'Avr bootloader sends the first time a NACK!!!
End Sub


Private Sub ReadHexFile()
Bigblock = 1
Blocknumber = 1                             'Set first Xmodem blocknumber
Bytecount = 3                               'Start data at bufferlocation 4 (3+1)
SendBuffer(1) = 1                           'Put SOH character in sendbuffer location 1
Do Until EOF(1)                             'Do until the end of the hex file
Main:
  Input #1, regel                           'Read 1 line from the file
  If IntelRecordtype(regel) = 2 Then GoTo Main 'Recordtype 2 is used to breakup intelhex files larger then 64K, ignore it en read the next line
  For lus = 1 To IntelBytecount(regel)      'Read all the bytes from the hexfile line
   Bytecount = Bytecount + 1                'Increase the bytecounter
   SendBuffer(Bytecount) = Hex2Dec(Mid(regel, (lus * 2) + 8, 2)) 'Convert the HEX value to dec and put it in the sendbuffer
  Next lus
  
  If Bytecount = 131 Or IntelRecordtype(regel) = 1 Then 'Buffer is full or end of file is reached
   
   If Bytecount < 131 Then                  'If the buffer is not completely filled (end of file) then fill it with &H1A (26dec)
        For lus = Bytecount To 131
          Bytecount = Bytecount + 1
          SendBuffer(Bytecount) = 26
        Next
   End If
   CalcChecksum                             'Goto sub to calculate the checksum
   If Send_Data = False Then
    Exit Sub       'Send data and if failed then exit the sub
   End If
   If Blocknumber = 255 Then                 'Blocklimit reaches it's limits, set it back to 0
     Blocknumber = 0                         'For some reason the 2e,3e, etc blocks startcounting from 0 instead of 1
     Bigblock = Bigblock + 1
   Else
     Blocknumber = Blocknumber + 1           'Increase the blocknumber
   End If
   Bytecount = 3                             'and reset the counter to the begin to process the next block
  End If

 
Loop                                        'Give me the next line from the eeprom file
Close #1                                    'Done everything bye, bye

FinalTransmission                           'Ready transmitting all blocks, finalize the transmitting
Text1 = Text1 & vbCrLf & "Ready, thanks have a nice day."
CloseComport                                'Close comport
End Sub

Public Sub CalcChecksum()                  'Calcs Xmodem checksum
Dim Templong As Long
SendBuffer(2) = Blocknumber                'Add blocknumber
SendBuffer(3) = (255 - Blocknumber)        'Add inversed blocknumber
For lus = 4 To 131                         'Add the 128 bytes
 Templong = Templong + SendBuffer(lus)
 'Debug.Print Hex(SendBuffer(lus)); " ";
Next lus
SendBuffer(132) = Templong Mod 256         'Calculate checksum and store it in the last byte
End Sub

Private Function Send_Data() As Boolean     'Send the data to the AVR
Send_Data = True
 Retry = 0                                  'First try
Send:
 Text1 = Text1 & vbCrLf & "Sending block: " & Bigblock & "." & Blocknumber                          'Show us something to watch
 Ack = False: Nack = False: AckTimeout = False  'Reset Nack and Ack flag
 For lus = 1 To 132
  CommX1.Send Chr(SendBuffer(lus))          'Send the buffer content out the commport incl.
 Next lus
    StartTimer (3500)                       'Start the timeout timer
    Do                                      'Do nothing until there's a Ack or nack
     DoEvents                               'Give cpu time back
    Loop Until Ack = True Or Nack = True Or AckTimeout = True
If Nack = True Or AckTimeout = True Then    'Nack received lets try it again
    Retry = Retry + 1                       'Incr retry counter
     Text1 = Text1 & vbCrLf & "Retry: " & Retry
     If Retry > 5 Then                      'To many retry's
        Beep
        Text1 = Text1 & vbCrLf & "ABORT To many retry's"
        Close #1                            'Close the file
        Send_Data = False
        Exit Function                       'Going out of here
     End If
    GoTo Send                               'Retry, so jumpp back to starting point sending
End If
Timer1.Enabled = False                      'Received Ack, timeout timer must be stopped
End Function
Private Function FinalTransmission()        'Finalize the tranmission with the AVR by sending 4dec
 Retry = 0                                  'First try
Send:
 Text1 = Text1 & vbCrLf & "Finalize Transmission"     'Show us something to watch
 Ack = False: Nack = False: AckTimeout = False                'Reset Nack and Ack flag
  CommX1.Send Chr(4)                        'Send init byte to the AVR
    StartTimer (2000)                       'Start the timeout timer
    Do                                      'Do nothing until there's a Ack or nack
     DoEvents                               'Give cpu time back
    Loop Until Ack = True Or Nack = True Or AckTimeout = True
If AckTimeout = True Then                   'Timeout occured lets try it again
    Retry = Retry + 1                       'Incr retry counter
     Text1 = Text1 & vbCrLf & "Retry: " & Retry
     If Retry > 5 Then                      'To many retry's
        Beep
        Text1 = Text1 & vbCrLf & "ABORT To many retry's"
        Exit Function                 'Going out of here
     End If
    GoTo Send                               'Retry, so jumpp back to starting point sending
End If
Timer1.Enabled = False                      'Received Nack, timeout timer must be stopped
End Function

Private Sub CommX1_OnReceive(ByVal DATA As String)
  Debug.Print Asc(DATA)
  Select Case DATA
  Case Is = Chr(6)                          'ACK received
   Ack = True: Nack = False
  Case Is = Chr(21)                         'NACK received
   Nack = True: Ack = False
  Case Else                                 'Everything else is nothing
   Nack = False: Ack = False
  End Select
End Sub

Private Sub Text1_Change()
Text1.SetFocus
Text1.SelStart = Len(Text1.Text)
End Sub

Private Sub Text2_Change()                  'Check of the selected eeprom file really exists
If FileExists(Text2) Then
    BtStart.Enabled = True
    Else
    BtStart.Enabled = False
End If
End Sub

Private Sub Form_Load()                     'Read the setting back from the registry
ComboComport = GetSetting("Evert", "BascomBootloader", "Commport", 1)
ComboBaud = GetSetting("Evert", "BascomBootloader", "CommBaud", 19200)
End Sub


Private Sub Timer1_Timer()
 AckTimeout = True                                'Timeout time reached, force Nack for retry
End Sub
