$regfile = "m1284pdef.dat"                                  ' specify the used micro
$crystal = 16000000                                         ' used crystal frequency
$baud = 38400                                               ' use baud rate
$hwstack = 150
$swstack = 150
$framesize = 120


Lcd_dat Alias Portc                                         'Define the hardware pins for the display, using 8bit 8088 mode
Lcd_cs Alias Portd.6
Lcd_rs Alias Portd.5
Lcd_rd Alias Portd.3
Lcd_wr Alias Portd.4
Lcd_rst Alias Portd.2


Config Lcd_dat = Output                                     'Set the hardware pins to output
Config Lcd_cs = Output
Config Lcd_rs = Output
Config Lcd_rd = Output
Config Lcd_wr = Output
Config Lcd_rst = Output


Enable Interrupts
$include "Config_mmc.bas"                                   ' Does drive init too
$include "Config_AVR-DOS.BAS"

'Config Spi = Hard , Interrupt = Off , Data Order = Msb , Master = Yes , Polarity = Low , Phase = 0 , Clockrate = 128 , Noss = 1
'Spiinit

Tp_cs Alias Portb.3                                         'CS pin touchpanel
Config Tp_cs = Output
Set Tp_cs
Config Portb.4 = Output



Dim I As Word , J As Word
Dim Tempb As Byte , Tempstr As String * 50

Declare Sub Write_command(byval Command As Word)
Declare Sub Write_data(byval Data16 As Word)
Declare Sub Lcd_init()
Declare Sub Lcd_reset()
Declare Sub Lcd_home()
Declare Sub Lcd_clear(byval Color As Word)
Declare Sub Lcd_pset(byval Xpos As Word , Byval Ypos As Word , Byval Color As Word)
Declare Sub Lcd_text(byval S As String , Byval Xoffset As Word , Byval Yoffset As Word , Byval Fontset As Byte , Byval Forecolor As Word , Byval Backcolor As Word)
Declare Sub Lcd_showpicture(byval Xoffset As Word , Byval Yoffset As Word)
Declare Sub Lcd_showpicture_sd(byval Filename$ As String , Byval Xoffset As Word , Byval Yoffset As Word)
Declare Sub Lcd_showpicture_bmp(byval Filename$ As String , Byval Xoffset As Word , Byval Yoffset As Word)
Declare Sub Lcd_setcursor(byval Xpos As Word , Byval Ypos As Word)
Declare Sub Lcd_line(byval Lx1 As Word , Byval Ly1 As Word , Byval Lx2 As Word , Byval Ly2 As Word , Byval Color As Word)
Declare Function Rgb16(byval Rgb8 As Byte) As Word

Declare Function Readtouch_y() As Word
Declare Function Readtouch_x() As Word

Const Black = &H0000
Const Blue = &H001F
Const Red = &HF800
Const Green = &H07E0
Const Cyan = &H07FF
Const Magenta = &HF81F
Const Yellow = &HFFE0
Const White = &HFFFF



'=== Main ===
Print "Init File System ... ";
Tempb = Initfilesystem(1)                                   ' Partition 1
If Tempb <> 0 Then
     Print "Error: " ; Tempb ; " at Init file system"
  Else
     Print "File system OK"
End If



Lcd_reset
Lcd_init
Do

Lcd_clear Black
Lcd_text "EVERTDEKKER.COM 2010" , 1 , 10 , 2 , Red , Black
Lcd_text "320x240 3.5' color tft touch screen" , 10 , 40 , 1 , Red , White
Lcd_text "-Supports Bascom font files in different sizes" , 10 , 50 , 3 , Green , Black
Lcd_text "-Bascom BGC graphics files form flash and," , 10 , 60 , 3 , Green , Black
Lcd_text " from SD (requires Avr-dos)" , 10 , 70 , 3 , Green , Black
Lcd_text "-Supports also Windows BMP file from SD" , 10 , 80 , 3 , Green , Black

Wait 7
Gosub Lcd_test
Wait 3
Lcd_clear Black

Lcd_text "BGC picture 132x132 loads from flash in 0.4sec" , 1 , 150 , 3 , Yellow , Black
Restore Plaatje                                             'FIRST restore you image before you can show it
Lcd_showpicture 10 , 10                                     'Show your image
Wait 5


Restore Girl                                                'FIRST restore you image before you can show it
Lcd_showpicture_sd "girl.bgc" , 150 , 10                    'Show your image
Lcd_text "BGC picture 132x132 from SD takes a bit longer," , 1 , 165 , 3 , Magenta , Black
Lcd_text "1 sec to load (nice girl ;-)" , 1 , 175 , 3 , Magenta , Black
Wait 5
Lcd_clear Black

Lcd_text "Windows BMP picture 300x172 24bpp from SD takes" , 1 , 190 , 3 , White , Black
Lcd_text "much longer, 5 seconds" , 1 , 200 , 3 , White , Black
Lcd_showpicture_bmp "wargame.bmp" , 10 , 10
Wait 5
Lcd_clear Black
Lcd_text " Some line's " , 10 , 10 , 3 , White , Red
Lcd_line 10 , 100 , 100 , 200 , Yellow
Lcd_line 90 , 12 , 240 , 3 , Red
Lcd_line 40 , 45 , 45 , 200 , Magenta
Lcd_line 121 , 178 , 200 , 221 , White
Lcd_line 239 , 213 , 56 , 180 , Blue
Lcd_line 67 , 86 , 255 , 2 , Cyan
Wait 5

Lcd_clear Black
Lcd_text "And touchpanel.." , 10 , 10 , 2 , White , Green
Lcd_text "Lower right corner to exit" , 180 , 200 , 4 , Red , Yellow
Do
Tempstr = "x: "
Tempstr = Tempstr + Str(readtouch_x())
Tempstr = Tempstr + " y: "
Tempstr = Tempstr + Str(readtouch_y())
Lcd_text "                 " , 10 , 30 , 4 , White , Black
Lcd_text Tempstr , 10 , 30 , 4 , White , Black
Waitms 100
If Readtouch_x() < 10000 And Readtouch_y() < 10000 Then Exit Do
Loop

Loop
End





Lcd_test:
 Lcd_home
 For I = 0 To 319
   For J = 0 To 239
    Select Case I
    Case Is > 279 : Write_data Black
    Case Is > 239 : Write_data Blue
    Case Is > 199 : Write_data Green
    Case Is > 159 : Write_data Cyan
    Case Is > 119 : Write_data Red
    Case Is > 79 : Write_data Magenta
    Case Is > 39 : Write_data Black
    Case Else Write_data White
    End Select
  Next J
  Next I
Return



'=== Subs ===
Sub Lcd_showpicture_bmp(byval Filename$ As String , Byval Xoffset As Word , Byval Yoffset As Word)       'Shows 24bit windows BMP
Local Startdata As Long , Xsize As Long , Ysize As Long , Xpos As Word , Ypos As Word
Local Tempx As Word , Tempy As Word , Readbyte As Long , Ff As Byte
Local Rgb16 As Word , Tempw As Word
Dim Buffer(3) As Byte
Ff = Freefile()
Open Filename$ For Binary As #ff
Get #ff , Readbyte , &H0B
Readbyte = Readbyte + 1
Get #ff , Xsize , &H13
Get #ff , Ysize , &H17

Xpos = 1 : Ypos = Ysize                                     'Set the pointers to 1
Tempx = Xpos + Xoffset                                      'Pixel position is the image position + the offset
Tempy = Ypos + Yoffset
Lcd_setcursor Tempx , Tempy                                 'Set the cursor to the start position of the image, sed2119 has auto increment ram adres, so only need to set xy position at start and y change
Do


Get #ff , Buffer(1) , Readbyte , 3                          'Buffer(1)=Bl Buffer(2)=gr Buffer(3)=rd
Shift Buffer(3) , Right , 3
Shift Buffer(2) , Right , 2
Shift Buffer(1) , Right , 3

Rgb16 = Buffer(3) * 2048
Tempw = Buffer(2) * 32
Rgb16 = Rgb16 + Tempw
Rgb16 = Rgb16 + Buffer(1)


Write_data Rgb16                                            'Write the pixel data to the display
     Readbyte = Readbyte + 3
      Incr Xpos
         If Xpos > Xsize Then                               'If the xpos is larger then xsize of the image start at a new y line
           Xpos = 1                                         'and set the xpos pos back to the first position on the new line
          Decr Ypos
          Tempx = Xpos + Xoffset                            'Pixel position is the image postion + the offset
          Tempy = Ypos + Yoffset
          Lcd_setcursor Tempx , Tempy                       'Start a new y line, send the xy position to the display
         End If
Loop Until Eof(#ff) <> 0
Close #ff
End Sub



Sub Lcd_showpicture_sd(byval Filename$ As String , Byval Xoffset As Word , Byval Yoffset As Word)       'Draw an Bascom BGC image on the lcd from SD card
Local Ysize As Byte , Xsize As Byte , Xpos As Word , Ypos As Word       'Dim some local variable
Local Tempx As Word , Tempy As Word , Ff As Byte
Local Imagesize As Word
Local L As Word , Pixel As Byte , Pixelword As Word , Prevpixel As Word , Repeat As Byte
Ff = Freefile()
Open Filename$ For Binary As #ff                            'Open the bgc file, take care that the path is correct
Get #ff , Ysize                                             'Read the first 4 bytes from the BGC, this contains info about the image
Get #ff , Xsize
Get #ff , Imagesize                                         'Byte 3&4 contains the image size
Xpos = 1 : Ypos = 1                                         'Set the pointers to 1
Tempx = Xpos + Xoffset                                      'Pixel position is the image position + the offset
Tempy = Ypos + Yoffset
Lcd_setcursor Tempx , Tempy                                 'Set the cursor to the start position of the image, sed2119 has auto increment ram adres, so only need to set xy position at start and y change
Do
Get #ff , Pixel                                             'Read the value for the pixel
    If Pixel = &HAA Then                                    'BGC file is lre coded &HAA represents this, the byte after &HAA is the number of times that the byte before &HAA wil be repeated
     Get #ff , Repeat                                       'Byte after &HAA contains the number of times to repeat
     Repeat = Repeat - 1
      For L = 1 To Repeat                                   'Loop the repeat
          Write_data Prevpixel                              'Write the pixel data to the display
          Decr Imagesize                                    'Decrease the bytes still to be processed
          Incr Xpos                                         'Incr the xpos
            If Xpos > Xsize Then                            'If the xpos is larger then xsize of the image start at a new y line
               Xpos = 1                                     'and set the xpos pos back to the first position on the new line
               Incr Ypos                                    'Start a new y line
               Tempx = Xpos + Xoffset                       'Pixel position is the image postion + the offset
               Tempy = Ypos + Yoffset
               Lcd_setcursor Tempx , Tempy
            End If
      Next L                                                'Next repeat loop
   Else                                                     'It's a regular byte, not LRE encoded
      Pixelword = Rgb16(pixel)                              'Convert the 8bit pixel to 16bit pixel
      Write_data Pixelword                                  'Write the pixel data to the display
      Prevpixel = Pixelword                                 'Store the pixel in a temp word, maybe we need it if the next byte is &HAA
      Decr Imagesize                                        'Decrease the bytes still to be processed
      Incr Xpos
         If Xpos > Xsize Then                               'If the xpos is larger then xsize of the image start at a new y line
           Xpos = 1                                         'and set the xpos pos back to the first position on the new line
          Incr Ypos
          Tempx = Xpos + Xoffset                            'Pixel position is the image postion + the offset
          Tempy = Ypos + Yoffset
          Lcd_setcursor Tempx , Tempy                       'Start a new y line, send the xy position to the display
         End If

End If
Loop Until Imagesize = 0                                    'Do until all bytes are processed
Close #ff
End Sub



Sub Lcd_showpicture(byval Xoffset As Word , Byval Yoffset As Word)       'Draw an Bascom BGC image on the lcd
' Important that you first RESTORE the image before calling this sub. Examp:  [ Restore Plaatje ]
Local Ysize As Byte , Xsize As Byte , Xpos As Word , Ypos As Word       'Dim some local variable
Local Tempx As Word , Tempy As Word
Local Imagesize As Word
Local L As Word , Pixel As Byte , Pixelword As Word , Prevpixel As Word , Repeat As Byte
Read Ysize                                                  'Read the first 4 bytes from the BGC, this contains info about the image
Read Xsize
Read Imagesize                                              'Byte 3&4 contains the image size
Xpos = 1 : Ypos = 1                                         'Set the pointers to 1
Tempx = Xpos + Xoffset                                      'Pixel position is the image position + the offset
Tempy = Ypos + Yoffset
Lcd_setcursor Tempx , Tempy                                 'Set the cursor to the start position of the image, sed2119 has auto increment ram adres, so only need to set xy position at start and y change

Do
Read Pixel                                                  'Read the value for the pixel
    If Pixel = &HAA Then                                    'BGC file is lre coded &HAA represents this, the byte after &HAA is the number of times that the byte before &HAA wil be repeated
     Read Repeat                                            'Byte after &HAA contains the number of times to repeat
     Repeat = Repeat - 1
      For L = 1 To Repeat                                   'Loop the repeat
          Write_data Prevpixel                              'Write the pixel data to the display
          Decr Imagesize                                    'Decrease the bytes still to be processed
          Incr Xpos                                         'Incr the xpos
            If Xpos > Xsize Then                            'If the xpos is larger then xsize of the image start at a new y line
               Xpos = 1                                     'and set the xpos pos back to the first position on the new line
               Incr Ypos                                    'Start a new y line
               Tempx = Xpos + Xoffset                       'Pixel position is the image postion + the offset
               Tempy = Ypos + Yoffset
               Lcd_setcursor Tempx , Tempy
            End If
      Next L                                                'Next repeat loop
   Else                                                     'It's a regular byte, not LRE encoded
      Pixelword = Rgb16(pixel)                              'Convert the 8bit pixel to 16bit pixel
      Write_data Pixelword                                  'Write the pixel data to the display
      Prevpixel = Pixelword                                 'Store the pixel in a temp word, maybe we need it if the next byte is &HAA
      Decr Imagesize                                        'Decrease the bytes still to be processed
      Incr Xpos
         If Xpos > Xsize Then                               'If the xpos is larger then xsize of the image start at a new y line
           Xpos = 1                                         'and set the xpos pos back to the first position on the new line
          Incr Ypos
          Tempx = Xpos + Xoffset                            'Pixel position is the image postion + the offset
          Tempy = Ypos + Yoffset
          Lcd_setcursor Tempx , Tempy                       'Start a new y line, send the xy position to the display
         End If

End If
Loop Until Imagesize = 0                                    'Do until all bytes are processed
End Sub


Sub Lcd_text(byval S As String , Byval Xoffset As Word , Byval Yoffset As Word , Byval Fontset As Byte , Byval Forecolor As Word , Byval Backcolor As Word)       'Print text on the display
Local Tempstring As String * 1 , Temp As Word               'Dim local the variables
Local A As Word , Pixels As Byte , Count As Byte , Carcount As Byte , Lus As Byte
Local Row As Byte , Byteseach As Byte , Blocksize As Byte , Dummy As Byte
Local Colums As Byte , Columcount As Byte , Rowcount As Byte , Stringsize As Byte
Local Xpos As Word , Ypos As Word , Pixel As Word , Pixelcount As Byte
Stringsize = Len(s) - 1                                     'Size of the text string -1 because we must start with 0
For Carcount = 0 To Stringsize                              'Loop for the numbers of caracters that must be displayed

 If Fontset = 1 Then Restore Font8x8                        'Add or remove here fontset's that you need or not,
 If Fontset = 2 Then Restore Font16x16                      'this is the name that you gave to the font, NOT the filename
 If Fontset = 3 Then Restore Font6x8                        'If you dont know the name, open the font file in wordpad, and there it is,
 If Fontset = 4 Then Restore Font5x5                        'right on top.

 Temp = Carcount + 1                                        'Cut the text string in seperate caracters
Tempstring = Mid(s , Temp , 1)
Read Row : Read Byteseach : Read Blocksize : Read Dummy     'Read the first 4 bytes from the font file
Temp = Asc(tempstring) - 32                                 'Font files start with caracter 32
For Lus = 1 To Temp                                         'Do dummie read to point to the correct line in the fontfile
   For Count = 1 To Blocksize
    Read Pixels
   Next Count
Next Lus
Colums = Blocksize / Row                                    'Calculate the numbers of colums
Row = Row * 8                                               'Row is always 8 pixels high = 1 byte, so working with row in steps of 8.
Row = Row - 1                                               'Want to start with row=0 instead of 1
Colums = Colums - 1                                         'Same for the colums
   For Rowcount = 0 To Row Step 8                           'Loop for numbers of rows
     A = Rowcount + Yoffset
       For Columcount = 0 To Colums                         'Loop for numbers of Colums
         Read Pixels
         Xpos = Columcount                                  'Do some calculation to get the caracter on the correct Xposition
         Temp = Carcount * Byteseach
         Xpos = Xpos + Temp
         Xpos = Xpos + Xoffset
            For Pixelcount = 0 To 7                         'Loop for 8 pixels to be set or not
               Ypos = A + Pixelcount                        'Each pixel on his own spot
               Pixel = Pixels.0                             'Set the pixel (or not)
                 If Pixel = 1 Then
                   Pixel = Forecolor
                 Else
                   Pixel = Backcolor
                 End If
                     Lcd_pset Xpos , Ypos , Pixel           'Finaly we can set the pixel
                     Shift Pixels , Right                   'Shift the byte 1 bit to the right so the next pixel comes availible
            Next Pixelcount
       Next Columcount
   Next Rowcount
Next Carcount
End Sub                                                     'End of this amazing subroutine


Function Readtouch_y() As Word                              'Read y value from ads7843
Local Tempspi As Byte , Adh As Byte , Adl As Byte
Local Spiregister As Byte
Spiregister = Spcr                                          'Save the spi spcr register to a temp variable to restore the settings after
Reset Spcr.2                                                'Set phase to 0
Reset Spcr.3
Tempspi = &H90                                              '12bit resolution
Reset Tp_cs
Spiout Tempspi , 1                                          'send 1 byte
Spiin Adl , 1                                               'Read the low byte
Spiin Adh , 1                                               'Read the high byte
Set Tp_cs
Readtouch_y = Makeint(adh , Adl)                            'Combine the high & low byte and give it back to the function
Spcr = Spiregister                                          'Restore the original spi register settings
End Function

Function Readtouch_x() As Word                              'Read x value from ads7843
Local Tempspi As Byte , Adh As Byte , Adl As Byte
Local Spiregister As Byte
Spiregister = Spcr                                          'Save the spi spcr register to a temp variable to restore the settings after
Reset Spcr.2                                                'Set phase to 0
Reset Spcr.3
Tempspi = &HD0                                              ''12bit resolution
Reset Tp_cs
Spiout Tempspi , 1                                          'send 1 byte
Spiin Adl , 1                                               'Read the low byte
Spiin Adh , 1                                               'Read the high byte
Set Tp_cs
Readtouch_x = Makeint(adh , Adl)                            'Combine the high & low byte and give it back to the function
Spcr = Spiregister                                          'Restore the original spi register settings
End Function


Sub Write_command(byval Command As Word)                    'Writes 16bit command to the display
Set Lcd_rd
Reset Lcd_rs
Reset Lcd_cs
Reset Lcd_wr
Lcd_dat = High(command)                                     'Cut the 16bits in 2 pieces and send the high part
Set Lcd_wr
Reset Lcd_wr
Lcd_dat = Low(command)                                      'send the low part of the 16bit to the display
Set Lcd_wr
Set Lcd_rs
Set Lcd_cs
End Sub


Sub Write_data(byval Data16 As Word)                        'Writes 16bit data to the display
Set Lcd_rd
Set Lcd_rs
Reset Lcd_cs
Reset Lcd_wr
Lcd_dat = High(data16)                                      'Cut the 16bits in 2 pieces and send the high part
Set Lcd_wr
Reset Lcd_wr
Lcd_dat = Low(data16)                                       'send the low part of the 16bit to the display
Set Lcd_wr
Set Lcd_cs
End Sub


Sub Lcd_clear(color As Word)                                'Clears the lcd screen
For I = 0 To 319
    For J = 0 To 239
     Write_data Color
    Next J
Next I
End Sub


Sub Lcd_reset()                                             'Resets the display
Set Lcd_cs
Set Lcd_rd
Set Lcd_wr
Set Lcd_rs
Set Lcd_rst
Waitms 10
Reset Lcd_rst
Waitms 500
Set Lcd_rst
Waitms 1000
End Sub


Sub Lcd_pset(byval Xpos As Word , Byval Ypos As Word , Byval Color As Word)       'Set 1 pixel to specified color
Lcd_setcursor Xpos , Ypos
Write_data Color
End Sub

Sub Lcd_setcursor(byval Xpos As Word , Byval Ypos As Word)  'Set the cursor to specified position
Write_command &H004E
Write_data Xpos                                             ' RAM Address counter set X
Write_command &H004F
Write_data Ypos                                             ' RAM Address counter set Y
Write_command &H0022
End Sub



Sub Lcd_line(byval Lx1 As Word , Byval Ly1 As Word , Byval Lx2 As Word , Byval Ly2 As Word , Byval Color As Word)       'Draw a line on the lcd
Local M As Word , M1 As Single , M2 As Single
Local Yg As Word , Cv As Single , Bn As Integer
Local R As Word , B As Word
M1 = Ly2 - Ly1
M2 = Lx2 - Lx1
Cv = M1 / M2
Bn = Int(cv)
M = Low(bn)
B = M * Lx1
B = -1 * B
B = B + Ly1
For R = Lx1 To Lx2
Yg = M * R
Yg = Yg + B
Lcd_pset R , Yg , Color
Next R
End Sub

Function Rgb16(byval Rgb8 As Byte) As Word                  'Convert the 8bit RRRGGGBB bgc data to 16 bit RRRRRGGGGGGBBBBB
Local Rd8 As Byte , Gr8 As Byte , Bl8 As Byte
Local Rd16 As Word , Gr16 As Word , Bl16 As Word , Tempword As Word
Bl8 = Rgb8 And &B00000011                                   'Exctract the blue bits from the byte
Shift Rgb8 , Right , 2                                      'Shift the 2 blue bits to heaven
Gr8 = Rgb8 And &B00000111                                   'Exctract the green bits from the byte
Shift Rgb8 , Right , 3                                      'Shift the 3 green bits to heaven
Rd8 = Rgb8 And &B00000111                                   'Exctract the red bits from the byte
Rd16 = Lookup(rd8 , Red16)                                  'look up the conversion in the tables
Gr16 = Lookup(gr8 , Green16)
Bl16 = Lookup(bl8 , Blue16)
Tempword = Rd16                                             'Add the 3 colors together to get the 16bit color
Tempword = Tempword + Gr16
Tempword = Tempword + Bl16
Rgb16 = Tempword                                            'Give the result back to the function
End Function

Sub Lcd_home
 Write_command &H004E                                       'Ram Address Set
 Write_data &H0000                                          'Page 58 of SSD2119 datasheet
 Write_command &H004F                                       'RAM address set
 Write_data &H0000                                          'Page 58 of SSD2119 datasheet

 Write_command &H0044                                       'Vertical Ram Address Position
 Write_data &HEF00                                          'Page 57 Of Ssd2119 Datasheet
 Write_command &H0045                                       'Horizontal Ram Address Position
 Write_data &H0000                                          'Page 57 Of Ssd2119 Datasheet
 Write_command &H0046                                       'Horizontal Ram Address Position
 Write_data &H013F                                          'Page 57 Of Ssd2119 Datasheet

 Write_command &H22                                         'Ram Data Write / Read
End Sub

Sub Lcd_init()
Lcd_reset
Write_command &H0028                                        'Vcom Otp
Write_data &H0006                                           'Page 55 -56 Of Ssd2119 Datasheet
Waitms 10
Write_command &H0000                                        'Start Oscillator
Write_data &H0001                                           'Page 36 Of Ssd2119 Datasheet
Write_command &H0010                                        'Sleep Mode
Write_data &H0000                                           'Page 49 Of Ssd2119 Datasheet
Write_command &H0001                                        'Driver Output Control
Write_data &H30EF                                           'Page 36 -39 Of Ssd2119 Datasheet
Write_command &H0002                                        'Lcd Driving Waveform Control
Write_data &H0600                                           'Page 40 -42 Of Ssd2119 Datasheet
Write_command &H0003                                        'Power Control 1
Write_data &H6A64                                           'Page 43 -44 Of Ssd2119 Datasheet
Write_command &H0011                                        'Entry Mode
Write_data &H6830                                           'Page 50 -52 Of Ssd2119 Datasheet
Write_command &H000F                                        'Gate Scan Position
Write_data &H0000                                           'Page 49 Of Ssd2119 Datasheet
Write_command &H000B                                        'Frame Cycle Control
Write_data &H5308                                           'Page 45 Of Ssd2119 Datasheet
Write_command &H000C                                        'Power Control 2
Write_data &H0003                                           'Page 47 Of Ssd2119 Datasheet
Write_command &H000D                                        'Power Control 3
Write_data &H000A                                           'Page 48 Of Ssd2119 Datasheet
Write_command &H000E                                        'Power Control 4
Write_data &H2E00                                           'Page 48 Of Ssd2119 Datasheet
Write_command &H001E                                        'Power Control 5
Write_data &H002B                                           'Page 53 Of Ssd2119 Datasheet
Write_command &H0025                                        'Frame Frequency Control
Write_data &H8000                                           'Page 53 Of Ssd2119 Datasheet
Write_command &H0026                                        'Analog Setting
Write_data &H7000                                           'Page 54 Of Ssd2119 Datasheet
Write_command &H004E                                        'Ram Address Set
Write_data &H0000                                           'Page 58 Of Ssd2119 Datasheet
Write_command &H004F                                        'Ram Address Set
Write_data &H0000                                           'Page 58 Of Ssd2119 Datasheet
Write_command &H0012                                        'Sleep Mode
Write_data &H08D9                                           'Page 49 Of Ssd2119 Datasheet
Write_command &H0030                                        'Gamma Control (R30h to R3Bh) -- Page 56 of SSD2119 datasheet
Write_data &H0000
Write_command &H0031
Write_data &H0104
Write_command &H0032
Write_data &H0100
Write_command &H0033
Write_data &H0305
Write_command &H0034
Write_data &H0505
Write_command &H0035
Write_data &H0305
Write_command &H0036
Write_data &H0707
Write_command &H0037
Write_data &H0300
Write_command &H003A
Write_data &H1200
Write_command &H003B
Write_data &H0800
Write_command &H0007                                        'Display Control
Write_data &H0033                                           'Page 45 Of Ssd2119 Datasheet
Waitms 200
Write_command &H22                                          'Ram Data Write / Read
End Sub

'=== data ===
Red16:                                                      'Lookup tabel rgb8 to rgb16 RRRRRGGGGGGBBBBB
Data &B0000000000000000% , &B0010000000000000% , &B0100100000000000% , &B0110100000000000% , &B1001000000000000% , &B1011000000000000% , &B1101000000000000% , &B1111100000000000%
Green16:
Data &B0000000000000000% , &B0000000100100000% , &B0000001001000000% , &B0000001110100000% , &B0000010010000000% , &B0000010110100000% , &B0000011011000000% , &B0000011111100000%
Blue16:
Data &B0000000000000000% , &B0000000000001010% , &B0000000000010101% , &B0000000000011111%

'=== Includes ===
$include "Font8x8.font"                                     'Includes here your font files
$include "Font16x16.font"                                   'If you don't need the files in your program, don't include them,
$include "Font6x8.font"                                     'these are flash memory eaters.
$include "Font5x5.font"

Plaatje:
$bgf "mcse.bgc"

Girl:
$bgf "girl.bgc"