$regfile = "m1284pdef.dat"                                  ' specify the used micro
$crystal = 16000000                                         ' used crystal frequency
$baud = 38400                                               ' use baud rate
$hwstack = 100                                              ' default use 32 for the hardware stack
$swstack = 100                                              ' default use 10 for the SW stack
$framesize = 40                                             ' default use 40 for the frame space



Waitus 1

Config Spi = Hard , Interrupt = Off , Data Order = Msb , Master = Yes , Polarity = Low , Phase = 0 , Clockrate = 128 , Noss = 1 , Spiin = 0

Declare Function Readtouch_y() As Word
Declare Function Readtouch_x() As Word


Enable Interrupts
$include "Config_mmc.bas"                                   ' Does drive init too
$include "Config_AVR-DOS.BAS"

Tp_cs Alias Portb.3
Config Tp_cs = Output
Set Tp_cs
Config Portb.4 = Output
Spiinit

Dim I As Word


Do

Waitms 100

I = Readtouch_x()
Print I ; "  " ;
I = Readtouch_y()
Print I
Loop
End



Function Readtouch_y() As Word                              'Read y value from ads7843
Local Tempspi As Byte , Adh As Byte , Adl As Byte
Local Spiregister As Byte
Spiregister = Spcr                                          'Save the spi spcr register to a temp variable to restore the settings after
Reset Spcr.2                                                'Set phase to 0
Reset Spcr.3
Tempspi = &H90                                              '12bit resolution
Reset Tp_cs
Spiout Tempspi , 1                                          'send 1 byte
Spiin Adl , 1                                               'Read the low byte
Spiin Adh , 1                                               'Read the high byte
Set Tp_cs
Readtouch_y = Makeint(adh , Adl)                            'Combine the high & low byte and give it back to the function
Spcr = Spiregister                                          'Restore the original spi register settings
End Function

Function Readtouch_x() As Word                              'Read x value from ads7843
Local Tempspi As Byte , Adh As Byte , Adl As Byte
Local Spiregister As Byte
Spiregister = Spcr                                          'Save the spi spcr register to a temp variable to restore the settings after
Reset Spcr.2
Reset Spcr.3                                                'Set phase to 0
Tempspi = &HD0                                              ''12bit resolution
Reset Tp_cs
Spiout Tempspi , 1                                          'send 1 byte
Spiin Adl , 1                                               'Read the low byte
Spiin Adh , 1                                               'Read the high byte
Set Tp_cs
Readtouch_x = Makeint(adh , Adl)                            'Combine the high & low byte and give it back to the function
Spcr = Spiregister                                          'Restore the original spi register settings
End Function